glcompat_attrs=4
class_crt=1

[VERTEX]

#include "common.glsl"

IN vec4 a_vert;

void main()
{
	gl_Position = u_projmodmat * a_vert;
}

[FRAGMENT]

#include "common.glsl"

lowp vec4 gmix05(lowp vec4 a, lowp vec4 b)
{
	lowp vec4 dif = abs(a-b);
	return mix(a,b,0.5)+dif*0.17;
}

void main()
{
	highp vec2 ip = gl_FragCoord.xy*u_viewportinv; // 1/(2046, 1536)
	mediump float pixof = 0.33/u_imgpixels.x; // 341, 256
	mediump float rowof = 0.25*u_scanlines/(u_imgpixels.y*u_maskpixels.y);
	highp vec2 mp = ip*u_imgpixels*u_maskscale; // (341, 256) * (0.5, 0.5)
	lowp vec4 c1 = gmix05(texture2D( u_tex, vec2(ip.x, ip.y-rowof) ),
			         texture2D( u_tex, vec2(ip.x, ip.y+rowof) ));
	lowp vec4 c2 = gmix05(texture2D( u_tex, vec2(ip.x+pixof, ip.y-rowof) ),
			         texture2D( u_tex, vec2(ip.x+pixof, ip.y+rowof) ));
	lowp vec4 c = gmix05(c1, c2);
	lowp vec4 m = texture2D( u_tex2, mp );
	gl_FragColor = c*m;
}
