glcompat_attrs=12
class_glcprogramext=1

[VERTEX]

#include "common.glsl"

IN vec4 a_vert;
IN vec4 a_texcoord;

OUT mediump vec2 v_texcoord;
OUT mediump float v_fog;

void main()
{
	gl_Position = u_projmodmat * a_vert;
	v_texcoord = vec2(u_texmat*vec4(a_texcoord));
	v_fog=clamp((gl_Position.z-u_fogstart)/(u_fogend-u_fogstart),0.0,1.0);
}

[FRAGMENT]

#include "common.glsl"

IN mediump vec2 v_texcoord;
IN mediump float v_fog;

void main()
{
	mediump vec4 c = texture2D(u_tex,v_texcoord);
	c.rgb = mix(c.rgb,u_fogcolor.rgb,v_fog);
	c = mix(texture2D(u_tex2, vec2((gl_FragCoord.x-u_viewport.x)/u_viewport.z, (gl_FragCoord.y-u_viewport.y)/u_viewport.w)), c, c.a);
	gl_FragColor = c;
}
